/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.reflection.item.crafting.IngredientReflection;
import noppes.npcs.util.Util;

public class NBTTags {
    public static HashMap<Integer, Boolean> getBooleanList(NBTTagList tagList) {
        HashMap<Integer, Boolean> list = new HashMap<Integer, Boolean>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74767_n("Boolean"));
        }
        return list;
    }

    public static Map<Integer, IItemStack> getIItemStackMap(NBTTagList tagList) {
        HashMap<Integer, IItemStack> list = new HashMap<Integer, IItemStack>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            ItemStack item = new ItemStack(nbttagcompound);
            if (item.func_190926_b()) continue;
            try {
                list.put(nbttagcompound.func_74771_c("Slot") & 0xFF, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
                continue;
            }
            catch (ClassCastException e) {
                list.put(nbttagcompound.func_74762_e("Slot"), Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
            }
        }
        return list;
    }

    public static NonNullList<Ingredient> getIngredientList(NBTTagList tagList) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            Ingredient ingredients;
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            if (nbttagcompound.func_150297_b("Ingredients", 9) && ((NBTTagList)nbttagcompound.func_74781_a("Ingredients")).func_150303_d() == 10) {
                NBTTagList ingredientsNBT = nbttagcompound.func_150295_c("Ingredients", 10);
                ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
                for (int j = 0; j < ingredientsNBT.func_74745_c(); ++j) {
                    ings.add(new ItemStack(ingredientsNBT.func_150305_b(j)));
                }
                ingredients = Ingredient.func_193369_a((ItemStack[])ings.toArray(new ItemStack[0]));
            } else {
                ingredients = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(nbttagcompound)});
            }
            list.add(nbttagcompound.func_74771_c("Slot") & 0xFF, (Object)ingredients);
        }
        return list;
    }

    public static ArrayList<int[]> getIntegerArraySet(NBTTagList tagList) {
        ArrayList<int[]> set = new ArrayList<int[]>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            set.add(compound.func_74759_k("Array"));
        }
        return set;
    }

    public static HashMap<Integer, Integer> getIntegerIntegerMap(NBTTagList tagList) {
        HashMap<Integer, Integer> list = new HashMap<Integer, Integer>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static List<Integer> getIntegerList(NBTTagList tagList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.add(nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static HashMap<Integer, Long> getIntegerLongMap(NBTTagList tagList) {
        HashMap<Integer, Long> list = new HashMap<Integer, Long>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74763_f("Long"));
        }
        return list;
    }

    public static HashSet<Integer> getIntegerSet(NBTTagList tagList) {
        HashSet<Integer> list = new HashSet<Integer>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.add(nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static HashMap<Integer, String> getIntegerStringMap(NBTTagList tagList) {
        HashMap<Integer, String> list = new HashMap<Integer, String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74779_i("Value"));
        }
        return list;
    }

    public static HashMap<ItemStack, Integer> getItemStackIntegerMap(NBTTagList tagList) {
        HashMap<ItemStack, Integer> list = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(new ItemStack(nbttagcompound.func_74775_l("Item")), nbttagcompound.func_74762_e("Value"));
        }
        return list;
    }

    public static void getItemStackList(NBTTagList tagList, NonNullList<ItemStack> items) {
        items.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            int slotId;
            NBTTagCompound nbtStack = tagList.func_150305_b(i);
            if (nbtStack.func_150297_b("Slot", 3)) {
                slotId = nbtStack.func_74762_e("Slot");
            } else {
                if (!nbtStack.func_150297_b("Slot", 1)) continue;
                slotId = nbtStack.func_74771_c("Slot") & 0xFF;
            }
            if (slotId < 0 || slotId >= items.size()) continue;
            items.set(slotId, (Object)new ItemStack(nbtStack));
        }
    }

    public static TreeMap<Long, String> GetLongStringMap(NBTTagList tagList) {
        TreeMap<Long, String> list = new TreeMap<Long, String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            if (nbt.func_150297_b("String", 8)) {
                list.put(nbt.func_74763_f("Long"), nbt.func_74779_i("String"));
            }
            if (!nbt.func_150297_b("String", 9) || ((NBTTagList)nbt.func_74781_a("String")).func_150303_d() != 8) continue;
            StringBuilder totalStr = new StringBuilder();
            for (NBTBase sNbt : nbt.func_150295_c("String", 8)) {
                totalStr.append(((NBTTagString)sNbt).func_150285_a_());
            }
            list.put(nbt.func_74763_f("Long"), totalStr.toString());
        }
        return list;
    }

    public static List<ScriptContainer> GetScript(NBTTagList list, IScriptHandler handler, boolean isClient) {
        ArrayList<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            ScriptContainer script = new ScriptContainer(handler, isClient);
            script.readFromNBT(compound, isClient);
            scripts.add(script);
        }
        return scripts;
    }

    public static HashMap<String, Integer> getStringIntegerMap(NBTTagList tagList) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74779_i("Slot"), nbttagcompound.func_74762_e("Value"));
        }
        return list;
    }

    public static List<String> getStringList(NBTTagList tagList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            String line = nbttagcompound.func_74779_i("Line");
            list.add(line);
        }
        return list;
    }

    public static NBTTagList nbtDoubleList(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        int i = values.length;
        for (int j = 0; j < i; ++j) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(values[j]));
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIItemStackMap(Map<Integer, IItemStack> inventory) {
        NBTTagList nbttaglist = new NBTTagList();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot : inventory.keySet()) {
            IItemStack item = inventory.get(slot);
            if (item == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            item.getMCItemStack().func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIngredientList(NonNullList<Ingredient> inventory) {
        NBTTagList nbttaglist = new NBTTagList();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack[] ings;
            Ingredient ingredient = (Ingredient)inventory.get(slot);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            NBTTagList ingredients = new NBTTagList();
            for (ItemStack ing : ings = IngredientReflection.getRawMatchingStacks(ingredient)) {
                ingredients.func_74742_a((NBTBase)ing.func_77955_b(new NBTTagCompound()));
            }
            nbttagcompound.func_74782_a("Ingredients", (NBTBase)ingredients);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIntegerArraySet(List<int[]> set) {
        NBTTagList nbttaglist = new NBTTagList();
        if (set == null) {
            return nbttaglist;
        }
        for (int[] arr : set) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74783_a("Array", arr);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIntegerCollection(Collection<Integer> set) {
        NBTTagList nbttaglist = new NBTTagList();
        if (set == null) {
            return nbttaglist;
        }
        for (int slot : set) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Integer", slot);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIntegerIntegerMap(Map<Integer, Integer> lines) {
        NBTTagList nbttaglist = new NBTTagList();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74768_a("Integer", lines.get(slot).intValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIntegerLongMap(HashMap<Integer, Long> lines) {
        NBTTagList nbttaglist = new NBTTagList();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74772_a("Long", lines.get(slot).longValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtIntegerStringMap(Map<Integer, String> map) {
        NBTTagList nbttaglist = new NBTTagList();
        if (map == null) {
            return nbttaglist;
        }
        for (int slot : map.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74778_a("Value", map.get(slot));
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtItemStackIntegerMap(Map<ItemStack, Integer> map) {
        NBTTagList nbttaglist = new NBTTagList();
        if (map == null) {
            return nbttaglist;
        }
        for (ItemStack item : map.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Item", (NBTBase)item.func_77955_b(new NBTTagCompound()));
            nbttagcompound.func_74768_a("Value", map.get(item).intValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtItemStackList(NonNullList<ItemStack> inventory) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack item = (ItemStack)inventory.get(slot);
            if (item.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", slot);
            item.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList NBTLongStringMap(Map<Long, String> map) {
        NBTTagList nbttaglist = new NBTTagList();
        if (map == null) {
            return nbttaglist;
        }
        for (long slot : map.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("Long", slot);
            String totalStr = map.get(slot);
            if (totalStr.length() < Short.MAX_VALUE) {
                nbt.func_74778_a("String", totalStr);
            } else {
                NBTTagList list = new NBTTagList();
                for (String line : Util.splitString(totalStr, 0)) {
                    list.func_74742_a((NBTBase)new NBTTagString(line));
                }
                nbt.func_74782_a("String", (NBTBase)list);
            }
            nbttaglist.func_74742_a((NBTBase)nbt);
        }
        return nbttaglist;
    }

    public static NBTTagCompound NBTMerge(NBTTagCompound data, NBTTagCompound merge) {
        NBTTagCompound compound = data.func_74737_b();
        Set names = merge.func_150296_c();
        for (String name : names) {
            NBTBase base = merge.func_74781_a(name);
            if (base.func_74732_a() == 10) {
                base = NBTTags.NBTMerge(compound.func_74775_l(name), (NBTTagCompound)base);
            }
            compound.func_74782_a(name, base);
        }
        return compound;
    }

    public static NBTTagList NBTScript(List<ScriptContainer> scripts) {
        NBTTagList list = new NBTTagList();
        for (ScriptContainer script : scripts) {
            NBTTagCompound compound = new NBTTagCompound();
            script.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public static NBTTagList nbtStringIntegerMap(Map<String, Integer> map) {
        NBTTagList nbttaglist = new NBTTagList();
        if (map == null) {
            return nbttaglist;
        }
        for (String slot : map.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("Slot", slot);
            nbttagcompound.func_74768_a("Value", map.get(slot).intValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static NBTTagList nbtStringList(List<String> list) {
        NBTTagList nbttaglist = new NBTTagList();
        for (String s : list) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("Line", s);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }
}

